<?php namespace Visiosoft\DopingsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\DopingsModule\PendingDoping\Contract\PendingDopingRepositoryInterface;
use Visiosoft\DopingsModule\PendingDoping\PendingDopingRepository;
use Anomaly\Streams\Platform\Model\Dopings\DopingsPendingDopingsEntryModel;
use Visiosoft\DopingsModule\PendingDoping\PendingDopingModel;
use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;
use Visiosoft\DopingsModule\Type\TypeRepository;
use Anomaly\Streams\Platform\Model\Dopings\DopingsTypesEntryModel;
use Visiosoft\DopingsModule\Type\TypeModel;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;
use Visiosoft\DopingsModule\Doping\DopingRepository;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Visiosoft\DopingsModule\Doping\DopingModel;
use Illuminate\Routing\Router;

class DopingsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
        DopingsModulePlugin::class,
    ];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/dopings/pending_dopings' => 'Visiosoft\DopingsModule\Http\Controller\Admin\PendingDopingsController@index',
        'admin/dopings/pending_dopings/create' => 'Visiosoft\DopingsModule\Http\Controller\Admin\PendingDopingsController@create',
        'admin/dopings/pending_dopings/edit/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\PendingDopingsController@edit',
        'admin/dopings/types' => 'Visiosoft\DopingsModule\Http\Controller\Admin\TypesController@index',
        'admin/dopings/types/create' => 'Visiosoft\DopingsModule\Http\Controller\Admin\TypesController@create',
        'admin/dopings/types/edit/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\TypesController@edit',
        'admin/dopings' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@index',
        'admin/dopings/create' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@create',
        'admin/dopings/edit/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@edit',
        'doping/{id}' => [
            'as' => 'add_doping',
            'uses' => 'Visiosoft\DopingsModule\Http\Controller\DopingsController@addDoping',
        ],
        'dopings/buy' => [
            'as' => 'doping::buy',
            'uses' => 'Visiosoft\DopingsModule\Http\Controller\DopingsController@buy',
        ],
        'admin/doping/approve/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@approve',
        'admin/doping/revert/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@revert',
        'showcase' => 'Visiosoft\DopingsModule\Http\Controller\DopingsController@showcase',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\DopingsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\DopingsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\DopingsModule\Event\ExampleEvent::class => [
        //    Visiosoft\DopingsModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\DopingsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        DopingsPendingDopingsEntryModel::class => PendingDopingModel::class,
        DopingsTypesEntryModel::class => TypeModel::class,
        DopingsDopingsEntryModel::class => DopingModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        PendingDopingRepositoryInterface::class => PendingDopingRepository::class,
        TypeRepositoryInterface::class => TypeRepository::class,
        DopingRepositoryInterface::class => DopingRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
