<?php namespace Visiosoft\DopingsModule\Type;

use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class TypeRepository extends EntryRepository implements TypeRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var TypeModel
     */
    protected $model;

    /**
     * Create a new TypeRepository instance.
     *
     * @param TypeModel $model
     */
    public function __construct(TypeModel $model)
    {
        $this->model = $model;
    }

	public function findBySlug($slug)
	{
		return $this->newQuery()->where('slug', $slug)->get();
	}

    public function findByAllSlug($slug = []){
        return $this->newQuery()->whereIn('slug',  $slug)->get();
    }

    public function getStatus()
    {
        return $this->status;
    }
}
