<?php

return [
    'home-ad-image' => [
        'type' => 'anomaly.field_type.file',
        'config' => [
            'folders' => ["images"],
            'mode' => 'upload',
        ]
    ],
    'home-ad-text' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
          'default_value' => 'visiosoft.module.dopings::messages.have_your_ad_here',
        ]
    ],
    'categoryShowcase' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
            'mode' => 'radio'
        ],
    ],
    'homePageLimit' => [
        'type' => 'anomaly.field_type.integer',
        'config' => [
            'min' => 0,
            'default_value' => 15,
        ],
    ],
    'dopings-create-roles' => [
        'type' => 'anomaly.field_type.checkboxes',
        'config' => [
            'default_value' => [
                'admin','user'
            ],
            'handler' => "\Visiosoft\DopingsModule\Handler\getRoles@handle"
        ],
    ],
    'listing-ad-background' => [
        'type' => 'anomaly.field_type.colorpicker',
        'config' => [
            'default_value' => '#ffc107',
        ]
    ],
    'listing-ad-text-color' => [
        'type' => 'anomaly.field_type.colorpicker',
        'config' => [
            'default_value' => '#000',
        ]
    ],
    'listing-ad-text' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => 'visiosoft.module.dopings::messages.listing_top_message',
        ]
    ]
];
