<?php namespace Visiosoft\DopingsModule\Doping;

use Anomaly\Streams\Platform\Model\Advs\AdvsAdvsEntryModel;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Anomaly\Streams\Platform\Model\Dopings\DopingsTypesEntryModel;
use Carbon\Carbon;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class DopingRepository extends EntryRepository implements DopingRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var DopingModel
     */
    protected $model;

    /**
     * Create a new DopingRepository instance.
     *
     * @param DopingModel $model
     */
    public function __construct(DopingModel $model)
    {
        $this->model = $model;
    }

    public function getDopingAds($id)
    {
        $types = $this->model->query()->where('status','approved')->where('adv_name_id', $id)->pluck('doping_type_id');
        return DopingsTypesEntryModel::query()->whereNotIn('dopings_types.id', $types)->get();
    }

    public function getDopingTypes($id)
    {
        return DopingsTypesEntryModel::query()->where('dopings_types.id', $id)->first();
    }
}
