<?php namespace Visiosoft\DopingsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;
use Visiosoft\DopingsModule\Doping\DopingModel;

class DopingsController extends PublicController
{

    private $repository;
    private $adv_model;
    private $model;

    public function __construct(AdvModel $advModel, DopingRepositoryInterface $repository, DopingModel $model)
    {
        $this->adv_model = $advModel;
        $this->model = $model;
        $this->repository = $repository;
        parent::__construct();
    }

    public function addDoping($id)
    {
        $this->adv_model->authControl();
        $dopings = $this->repository->getDopingAds($id);

        if (count($dopings) == 0) {
            return redirect(route('adv_detail', $id))->with('success', [trans('visiosoft.module.advs::field.all_dopings_added')]);
        }

        return $this->view->make('visiosoft.module.dopings::buy', compact('id', 'dopings'));
    }

    public function buy()
    {
        $this->adv_model->authControl();

        if (isset($this->request->all()['action']) == "save") {

            $new_doping = $this->request->request->all();
            unset($new_doping['action'], $new_doping['_token']);
            $new_doping['user_id'] = Auth::id();

            foreach ($this->request->doping as $doping) {
                $doping_type = $this->repository->getDopingTypes($doping);
                $doping = new DopingsDopingsEntryModel();
                $doping->price = $doping_type->price;
                $doping->expiry_date = null;
                $doping->name = $doping_type->name;
                $doping->adv_name = $this->request->adv_name;
                $doping->doping_type = $doping_type->id;
                $doping->user = Auth::id();
                $doping->status = "in_cart";
                $doping->save();

                $response = $this->AddCart($doping);
            }

            if (!is_null($response)) {
                return redirect($response);
            }
            return $this->view->make('visiosoft.module.dopings::doping_request');
        }
    }

    public function AddCart($doping)
    {
        $this->adv_model->authControl();

        if ($this->adv_model->is_enabled('carts')) {
            $cart = $this->dispatch(new GetCart());
            $cart->add($doping, 1);
            return url('visiosoft.module.carts::cart');
        }
        return null;
    }

    public function search($query, $param)
    {
        if ($param == null) {
            $doping_advs_ids = $this->model->getFeaturedAds(3);
            $query = $query->whereIn('advs_advs.id', $doping_advs_ids);
        }
        if (!empty($param['doping']) and $param['doping'] == "urgent") {
            $doping_advs_ids = $this->model->getFeaturedAds(5);
            $query = $query->whereIn('advs_advs.id', $doping_advs_ids);
        } else {
            $top_category_showcase_list = $this->model->getFeaturedAds(2);

            $query = $query->leftJoin('dopings_dopings', function ($join) {
                $join->on('advs_advs.id', '=', 'dopings_dopings.adv_name_id');
                $join->where('dopings_dopings.doping_type_id', '=', 4);
                $join->where('dopings_dopings.status', 'approved');
                $join->where('dopings_dopings.expiry_date', '>', Carbon::now());
            });
        }
        return $query;
    }

    public function querySelect($query, $param)
    {
        if (!empty($param['doping']) and $param['doping'] == "urgent") {
            $query = $query->select('advs_advs.*', 'advs_advs_translations.name as name',
                'advs_advs_translations.advs_desc as advs_desc');
        } else {
            $query = $query->select('advs_advs.*', 'advs_advs_translations.name as name',
                'advs_advs_translations.advs_desc as advs_desc', 'dopings_dopings.id as doping');
        }
        return $query;
    }


    public function listFeatures($advs)
    {
        $featured_advs = $this->model->filterAdvs(2, $advs);

        foreach ($featured_advs as $index => $ad) {
            $featured_advs[$index]->detail_url = $this->adv_model->getAdvDetailLinkByModel($ad, 'list');
            $featured_advs[$index] = $this->adv_model->AddAdsDefaultCoverImage($ad);
        }

        return $featured_advs;
    }

}
