<?php namespace Visiosoft\DopingsModule\Package;

use Visiosoft\DopingsModule\Package\Contract\PackageRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class PackageRepository extends EntryRepository implements PackageRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var PackageModel
     */
    protected $model;

    /**
     * Create a new PackageRepository instance.
     *
     * @param PackageModel $model
     */
    public function __construct(PackageModel $model)
    {
        $this->model = $model;
    }

    public function getPackagesWithTypeAndCategory($type_id, $category_id)
    {
        return $this->newQuery()
            ->where('category_id', $category_id)
            ->where('type_id', $type_id)
            ->get();
    }
}
