<?php namespace Visiosoft\DopingsModule\Doping\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Visiosoft\DopingsModule\Doping\Table\DopingTableBuilder;
use Visiosoft\DopingsModule\Events\DopingApproved;
use Visiosoft\DopingsModule\Package\Contract\PackageRepositoryInterface;
use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;

class Approve extends ActionHandler
{
    public function handle(DopingTableBuilder $builder, array $selected, TypeRepositoryInterface $typeRepository, PackageRepositoryInterface $packageRepository)
    {
        $model = $builder->getTableModel();
        $now = Carbon::now();

        foreach ($selected as $id) {
            $doping = $model->newQuery()->find($id);
            $dopingDuration = $typeRepository->find($doping->doping_type_id);

            if ($doping->status !== 'approved') {

                if ($doping->package_id) {
                    if ($package = $packageRepository->find($doping->package_id)) {
                        $doping->update([
                            'status' => 'approved',
                            'expiry_date' => $now->add($package->interval, Str::lower($package->interval_period)),
                        ]);
                    }
                } else {
                    $doping->update([
                        'status' => 'approved',
                        'expiry_date' => $now->addDays($dopingDuration->duration),
                    ]);
                }

                event(new DopingApproved($doping));
            }
        }

        if ($selected) {
            $this->messages->success(trans('visiosoft.module.advs::field.approved'));
        }
    }
}