<?php namespace Visiosoft\DopingsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;
use Visiosoft\DopingsModule\Doping\DopingModel;
use Visiosoft\DopingsModule\Package\Contract\PackageRepositoryInterface;
use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;

class DopingsController extends PublicController
{

    private $repository;
    private $adv_model;
    private $model;
    private $category;
    private $typeRepository;
    protected $packageRepository;
    protected $advRepository;

    public function __construct(
        AdvModel $advModel,
        DopingRepositoryInterface $repository,
        DopingModel $model,
        CategoryRepositoryInterface $category,
        PackageRepositoryInterface $packageRepository,
        TypeRepositoryInterface $typeRepository,
        AdvRepositoryInterface $advRepository
    )
    {
        $this->adv_model = $advModel;
        $this->model = $model;
        $this->category = $category;
        $this->repository = $repository;
        $this->packageRepository = $packageRepository;
        $this->typeRepository = $typeRepository;
        $this->advRepository = $advRepository;
        parent::__construct();
    }

    public function addDoping($id)
    {

        $cart = $this->dispatch(new GetCart());
        $redirectLink = route('adv_detail', [$id]);
	    if (count($cart->items) &&
		        (setting_value('visiosoft.module.packages::allow_pending_ad_creation') ||
			        setting_value('visiosoft.module.packages::move_the_buy_package_to_the_end') )) {
            $redirectLink = route('visiosoft.module.carts::carts.review');
        }
        return $this->view->make('visiosoft.module.dopings::buy', compact('id', 'redirectLink'));
    }

    public function buy()
    {
        $request_params = request()->all();

        $request_params['package_status'] = false;

        foreach ($request_params as $index => $param) {
            if (substr($index, 0, 8) === "package-") {
                $request_params['package_status'] = true;
                $request_params['package'][] = $param;
            }
        }

        $this->middleware('auth');

        if (isset($request_params['action']) == "save" and (request()->has('doping') or $request_params['package_status'])) {
            $new_doping = $this->request->request->all();
            unset($new_doping['action'], $new_doping['_token']);
            $new_doping['user_id'] = Auth::id();

            if (request()->has('doping')) {
                foreach ($request_params['doping'] as $doping) {
                    $doping_type = $this->typeRepository->find($doping);
                    $doping = new DopingsDopingsEntryModel();
                    $doping->price = $doping_type->price;
                    $doping->expiry_date = null;
                    $doping->name = $doping_type->name;
                    $doping->adv_name = $this->request->adv_name;
                    $doping->doping_type = $doping_type->id;
                    $doping->currency = setting_value('streams::currency');
                    $doping->user = Auth::id();
                    $doping->status = "in_cart";
                    $doping->save();

                    $response = $this->AddCart($doping);
                }
            }

            if ($request_params['package_status']) {
                foreach ($request_params['package'] as $package) {
                    $package = $this->packageRepository->find($package);
                    $doping = new DopingsDopingsEntryModel();
                    $doping->price = $package->price;
                    $doping->name = $package->type->name
                        ."-".$package->interval."-".
                        $package->interval_period;
                    $doping->adv_name = $this->request->adv_name;
                    $doping->currency = setting_value('streams::currency');
                    $doping->package_id = $package->id;
                    $doping->doping_type = $package->type_id;
                    $doping->user = Auth::id();
                    $doping->status = "in_cart";
                    $doping->save();

                    $response = $this->AddCart($doping);
                }
            }
	        $cart = $this->dispatch(new GetCart());

            if (!is_null($response)) {
                return redirect()->route('visiosoft.module.carts::carts.review');
            }
            return $this->view->make('visiosoft.module.dopings::doping_request');
        }
        $this->messages->error(trans('visiosoft.module.dopings::messages.make_selection'));
        return $this->redirect->to('/doping/' . $this->request->adv_name);
    }

    public function myDopings()
    {
        $myDopings = $this->repository->getUserDopings();

        return $this->view->make('visiosoft.module.dopings::my-dopings', compact('myDopings'));
    }

    public function AddCart($doping)
    {
        $this->middleware('auth');

        if ($this->adv_model->is_enabled('carts')) {
            $cart = $this->dispatch(new GetCart());
            $cart->add($doping, 1);
            return route('visiosoft.module.carts::cart');
        }
        return null;
    }

    public function search($query, $param)
    {
        $categorySlug = $this->request->segment(2);
        $category = $this->category->findBySlug($categorySlug);

        if (!is_null($category) and is_null($category->parent_category_id) and !isset($param['doping'])) {
            if (setting_value('visiosoft.module.dopings::categoryShowcase')) {
                //Category Showcase
                $doping_advs_ids = $this->model->getFeaturedAds(3);
                $query = $query->whereIn('advs_advs.id', $doping_advs_ids);
            }
        }
        if (!empty($param['doping'])) {
            $doping_types = [
                5 => 'urgent',
                1 => 'showcase',
                7 => 'markdown'
            ];

            if ($type = array_search($param['doping'], $doping_types)) {
                // Select Doping Type
                $doping_advs_ids = $this->model->getFeaturedAds($type);
                $query = $query->whereIn('advs_advs.id', $doping_advs_ids);
            }
        } else {
            // Featured Ad
            $query = $query->leftJoin('dopings_dopings', function ($join) {
                $join->on('advs_advs.id', '=', 'dopings_dopings.adv_name_id');
                $join->where('dopings_dopings.doping_type_id', '=', 4);
                $join->where('dopings_dopings.status', 'approved');
                $join->where('dopings_dopings.expiry_date', '>', Carbon::now());
            });
        }
        return $query;
    }

    public function querySelect($query, $param)
    {
        $doping_types = [
            5 => 'urgent',
            1 => 'showcase',
            7 => 'markdown'
        ];

        if (!empty($param['doping']) and $type = array_search($param['doping'], $doping_types)) {
            $query = $query->select('advs_advs.*', 'advs_advs_translations.name as name',
                'advs_advs_translations.advs_desc as advs_desc');
        } else {
            $query = $query->select('advs_advs.*', 'advs_advs_translations.name as name',
                'advs_advs_translations.advs_desc as advs_desc', 'dopings_dopings.id as doping',
                'doping_type_id as doping_type');
        }
        return $query;
    }


    public function listFeatures($advs)
    {
        $featured_advs = $this->model->filterAdvs(2, $advs)->inRandomOrder()->paginate(setting_value('streams::per_page'));


        $ad_id_list = $featured_advs->pluck('id')->all();

        $featured_advs = $this->advRepository->addAttributes($featured_advs);

        foreach ($featured_advs as $index => $ad) {
            $featured_advs[$index]->detail_url = $this->adv_model->getAdvDetailLinkByModel($ad, 'list');
            $featured_advs[$index] = $this->adv_model->AddAdsDefaultCoverImage($ad);
        }

        return ['featured_ads' => $featured_advs, 'ad_id_list' => $ad_id_list];
    }

    public function showcase()
    {
        $this->template->set('meta_title', trans('visiosoft.module.dopings::button.showcase'));
        return $this->view->make('visiosoft.module.dopings::showcase/showcase');
    }

    public function getPendingDopingCount()
    {
        $myAdvsPendingDoping = $this->repository->newQuery()->where('status', 'pending_approve');
        return count($myAdvsPendingDoping->get());
    }
}
