<?php namespace Visiosoft\DopingsModule\Doping;

use Anomaly\Streams\Platform\Model\Advs\AdvsAdvsEntryModel;
use Carbon\Carbon;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\DopingsModule\Doping\Contract\DopingInterface;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;

class DopingModel extends DopingsDopingsEntryModel implements DopingInterface
{

    public function getFeaturedAdvs($typeId)
    {
        $dopings = $this->newQuery()
            ->where('doping_type_id', $typeId)
            ->where('status', 'approved')
            ->where('expiry_date', '>', Carbon::now())
            ->inRandomOrder()
            ->pluck('adv_name_id');

        $doping_advs = AdvModel::query()
            ->where('advs_advs.slug', '!=', "")
            ->where('advs_advs.status', 'approved')
            ->where('advs_advs.finish_at', '>', date('Y-m-d H:i:s'))
            ->whereIn('advs_advs.id', $dopings)
            ->inRandomOrder();

        return $doping_advs->paginate(setting_value('visiosoft.module.dopings::homePageLimit', setting_value('streams::per_page')));
    }

    public function getFeaturedAds($type)
    {
        $dopings = $this->newQuery()
            ->where('doping_type_id', $type)
            ->where('status', 'approved')
            ->where('expiry_date', '>', Carbon::now())
            ->inRandomOrder()
            ->pluck('adv_name_id');
        return AdvsAdvsEntryModel::query()
            ->whereIn('advs_advs.id', $dopings)
            ->inRandomOrder()
            ->pluck('id');
    }

    public function getFeaturesWithDopingsAndAds($typeId)
    {
        return $this->newQuery()
            ->where(function ($query) use ($typeId) {
                if (is_array($typeId)){
                    return $query->whereIn('doping_type_id', $typeId);
                }
                return $query->where('doping_type_id', $typeId);
            })
            ->where('status', 'approved')
            ->where('expiry_date', '>', Carbon::now())
            ->inRandomOrder()
            ->paginate(setting_value('visiosoft.module.dopings::homePageLimit', setting_value('streams::per_page')));
    }

    public function filterAdvs($type, $advs)
    {
        $ids = $this->getFeaturedAds($type);
        return $advs->whereIn('advs_advs.id', $ids);
    }

    public function reFilterAdvs($type, $advs)
    {
        $ids = $this->getFeaturedAds($type);
        return $advs->whereNotIn('id', $ids);
    }

    public function approve($duration)
    {
        $this->update([
            'status' => 'approved',
            'expiry_date' => Carbon::now()->addDays($duration),
        ]);
    }

    public function disapprove()
    {
        $this->update([
            'status' => 'pending_approve',
            'expiry_date' => null,
        ]);
    }

    public function getType()
    {
        return $this->doping_type;
    }

    public function approved()
    {
        $this->setAttribute('status', 'approved');
        $this->save();
    }
}
