<?php namespace Visiosoft\DopingsModule\Doping;

use Anomaly\Streams\Platform\Model\Advs\AdvsAdvsEntryModel;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Anomaly\Streams\Platform\Model\Dopings\DopingsTypesEntryModel;
use Carbon\Carbon;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class DopingRepository extends EntryRepository implements DopingRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var DopingModel
     */
    protected $model;

    /**
     * Create a new DopingRepository instance.
     *
     * @param DopingModel $model
     */
    public function __construct(DopingModel $model)
    {
        $this->model = $model;
    }

    public function getDopingAds($id)
    {
        $types = $this->model->query()
            ->where('status', 'approved')
            ->where('adv_name_id', $id)
            ->where('dopings_dopings.expiry_date', '>=', Carbon::now())
            ->pluck('doping_type_id');

        return DopingsTypesEntryModel::query()
            ->whereNotIn('dopings_types.id', $types)
            ->get();
    }

    public function getActiveDopingsForAd($id)
    {
        return $this->model->query()
            ->where('status', 'approved')
            ->where('adv_name_id', $id)
            ->where('dopings_dopings.expiry_date', '>=', Carbon::now())
            ->get();
    }

    public function getDopingTypes($id)
    {
        return DopingsTypesEntryModel::query()->where('dopings_types.id', $id)->first();
    }

    public function getUserDopings($userId = null)
    {
        $userId = $userId ?: auth()->id();

        return $this
            ->newQuery()
            ->where('user_id', $userId)
            ->whereIn('status', ['pending_approve', 'approved'])
            ->get();
    }
}
