<?php namespace Visiosoft\DopingsModule;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Model\Dopings\DopingsTypesEntryModel;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Visiosoft\DopingsModule\Doping\DopingModel;

class DopingsModuleSeeder extends Seeder
{
    public function run()
    {
        DB::table('dopings_types')->truncate();
        DB::table('dopings_dopings')->truncate();
        DB::table('dopings_dopings_translations')->truncate();
        DopingsTypesEntryModel::create([
            'en' => [
                'name' => 'Home Page Showcase',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'
            ],
            'tr' => [
                'name'  => 'Ana Sayfa Vitrin',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'price' => 100,
            'duration' => 30,
            'icon' => 'heart'
        ]);
        DopingsTypesEntryModel::create([
            'en' => [
                'name' => 'Top Category Showcase',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'tr' => [
                'name'  => 'Ust Kategori Vitrin',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'price' => 200,
            'duration' => 15,
            'icon' => 'globe'
        ]);
        DopingsTypesEntryModel::create([
            'en' => [
                'name' => 'Category Showcase',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'tr' => [
                'name'  => 'Kategori Vitrini',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'price' => 300,
            'duration' => 7,
            'icon' => 'pencil'
        ]);
        DopingsTypesEntryModel::create([
            'en' => [
                'name' => 'Featured Ad',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'tr' => [
                'name'  => 'Farkliyim',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'price' => 350,
            'duration' => 5,
            'icon' => 'home'
        ]);
        Model::unguard();
        DB::unprepared(file_get_contents(__DIR__.'/demo.sql'));
        Model::reguard();
    }
}