<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\UsersModule\User\UserModel;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\DopingsModule\Doping\DopingModel;
use Visiosoft\DopingsModule\Type\TypeModel;

class VisiosoftModuleDopingsCreateDopingsFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'slug' => [
            'type' => 'anomaly.field_type.slug',
            'config' => [
                'slugify' => 'name',
                'type' => '_'
            ],
        ],
        'adv_name' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => AdvModel::class
            ]
        ],
        'doping_type' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => TypeModel::class
            ]
        ],
        'duration' => 'anomaly.field_type.integer',
        'description' => 'anomaly.field_type.textarea',
        'price' => 'anomaly.field_type.integer',
        'is_active' => 'anomaly.field_type.boolean',
        'icon' => 'anomaly.field_type.text',
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class
            ]
        ],
        'currency' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'handler' => 'currencies',
                'default_value' => 'USD',
            ],
        ],
        'expiry_date' => 'anomaly.field_type.datetime',
        'status' => 'anomaly.field_type.text',
    ];

}
