<?php namespace Visiosoft\DopingsModule\Doping;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;

class DopingCriteria extends EntryCriteria
{
    protected $repository;

    public function __construct(DopingRepositoryInterface $repository)
    {
        $this->repository = $repository;
    }

    public function  getActiveDopingsWithAd($id)
    {
        return $this->repository->getAdsActiveDopings($id);
    }

    public function  getActivePackagesWithAd($id)
    {
        return $this->repository->getAdsActivePackages($id);
    }
}
