<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class VisiosoftModuleDopingsOpenedTrashableDopings extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('dopings_dopings', 'deleted_at')) {
        	Schema::table('dopings_dopings', function (Blueprint $table) {
        		$table->dateTime('deleted_at')->nullable();
	        });
        }

        $this->streams()
	        ->findBySlugAndNamespace('dopings', 'dopings')
	        ->setAttribute('trashable', true)
	        ->save();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
	    $this->streams()
		    ->findBySlugAndNamespace('dopings', 'dopings')
		    ->setAttribute('trashable', false)
		    ->save();

    }
}
