<?php namespace Visiosoft\DopingsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;

class DopingsController extends PublicController
{

    private $repository;
    private $adv_model;

    public function __construct(AdvModel $advModel, DopingRepositoryInterface $repository)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }

        $this->adv_model = $advModel;
        $this->repository = $repository;
        parent::__construct();
    }

    public function addDoping($id)
    {
        $dopings = $this->repository->getDopingAds($id);

        if (count($dopings) == 0) {
            return redirect(route('adv_detail', $id))->with('success', [trans('visiosoft.module.advs::field.all_dopings_added')]);
        }

        return $this->view->make('visiosoft.module.dopings::buy', compact('id', 'dopings'));
    }

    public function buy()
    {
        if (isset($this->request->all()['action']) == "save") {

            $new_doping = $this->request->request->all();
            unset($new_doping['action'], $new_doping['_token']);
            $new_doping['user_id'] = Auth::id();

            foreach ($this->request->doping as $doping) {
                $doping_type = $this->repository->getDopingTypes($doping);
                $doping = new DopingsDopingsEntryModel();
                $doping->price = $doping_type->price;
                $doping->expiry_date = null;
                $doping->name = $doping_type->name;
                $doping->adv_name = $this->request->adv_name;
                $doping->doping_type = $doping_type->id;
                $doping->user = Auth::id();
                $doping->status = "in_cart";
                $doping->save();

                $response = $this->AddCart($doping);
            }

            if (!is_null($response)) {
                return redirect($response);
            }
            return $this->view->make('visiosoft.module.dopings::doping_request');
        }
    }

    public function AddCart($doping)
    {
        if ($this->adv_model->is_enabled('carts')) {
            $cart = $this->dispatch(new GetCart());
            $cart->add($doping, 1);
            return url('visiosoft.module.carts::cart');
        }
        return null;
    }

}
