<?php namespace Visiosoft\DeployModule\Site\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class SiteFormBuilder extends FormBuilder
{

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'domain' => [
            'placeholder' => 'example.com',
        ],
        'username' => [
            'label' => 'visiosoft.module.deploy::field.username.name',
            'type' => 'anomaly.field_type.text',
            'placeholder' => 'example',
        ],
        'php' => [
            'label' => 'visiosoft.module.deploy::field.php.name',
            'type' => 'anomaly.field_type.text',
            'placeholder' => '7.4',
            'value' => '7.4',
        ],
        'basepath' => [
            'label' => 'visiosoft.module.deploy::field.basepath.name',
            'type' => 'anomaly.field_type.text',
            'placeholder' => 'public',
            'value' => 'public',
        ],
        'recipes' => [
            'label' => 'visiosoft.module.deploy::field.recipes.name',
            'type' => 'anomaly.field_type.tags',
            'placeholder' => 'recipe_key',
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [];

    public function setOptions($options)
    {
        return parent::setOptions([
            'success_message' => false,
            'redirect' => '/admin/site',
            'title' => 'visiosoft.module.site::button.new_site',
            'description' => setting_value('visiosoft.module.site::form_description')
        ]);
    }

}
