<?php namespace Visiosoft\DeployModule\Jobs;

use Anomaly\Streams\Platform\Support\Collection;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\DeployModule\Helpers\HandleError;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class AddSSL implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $siteId;
    protected $domain;

    public function __construct($siteId, $domain)
    {
        $this->siteId = $siteId;
        $this->domain = $domain;
    }

    public function handle(SiteRepositoryInterface $siteRepository)
    {
        $endpointURL = setting_value('visiosoft.module.deploy::endpoint_url');
        $apiKey = setting_value('visiosoft.module.deploy::api_key');

        if (!$endpointURL || !$apiKey) {
            throw new \Exception(trans('module::message.update_api_settings'));
        }

        $site = $siteRepository->find($this->siteId);

        $uuid = $site->getAttribute('site_uuid');

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpointURL . '/api/alias/ssl',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => [
                'siteId' => $uuid,
                'domain' => $this->domain,
            ],
            CURLOPT_HTTPHEADER => array(
                'Accept: application/json',
                'Authorization: Apikey ' . $apiKey
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $response = new Collection(json_decode($response, true));

        if ($response->has('errors') && count($response->get('errors'))) {
            dispatch_sync(new HandleError($response->get('errors')));
        }

        return $response->get('data');
    }
}