<?php namespace Visiosoft\DeployModule\Listeners;

use Visiosoft\SiteModule\Command\CheckSite;
use Visiosoft\SiteModule\Site\Event\CheckActivatedSite;

class GetActivatedSite
{
    public function handle(CheckActivatedSite $event)
    {
        $site = $event->getSite();

        // Verify for Site base URL
        $url = "http://" . $site->getUrl();

        $response = dispatch_sync(new CheckSite($url));

        return $response['verify'];
    }
}
