<?php namespace Visiosoft\DeployModule\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class CreateOpenclassify implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $siteId;

    public function __construct($siteId)
    {
        $this->siteId = $siteId;
    }

    public function handle(SiteRepositoryInterface $siteRepository)
    {
        $site = $siteRepository->find($this->siteId);

        $creator = new CreateSite($site->username(), $site->getUrl(), '7.4', 'public');
        $response = $creator->handle();

        $uuid = $response['site_id'];

        $site->setAttribute('site_uuid', $uuid);
        $site->save();

        (new RunRecipe($uuid, 'create-openclassify'))->handle();
    }
}