<?php namespace Visiosoft\DeployModule\Site\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\Streams\Platform\Support\Collection;
use Visiosoft\DeployModule\Site\Command\RecipeRunner;
use Visiosoft\DeployModule\Site\Command\SiteCreator;

class SiteFormHandler
{
    public function handle(SiteFormBuilder $builder,MessageBag $messages)
    {
        if (!$builder->canSave()) {
            return;
        }

        $username = $builder->getPostValue('username');
        $domain = $builder->getPostValue('domain');
        $php = $builder->getPostValue('php');
        $basepath = $builder->getPostValue('basepath');
        $recipes = json_decode($builder->getPostValue('recipes'), true);
        $recipes = new Collection($recipes);

        $creator = new SiteCreator();
        $res = $creator->create($domain, $username, $php, $basepath);

        if (!$res) {
            $builder->setFormResponse(redirect('/admin/deploy/create'));
            return;
        }

        if ($res) {
            $entry = $builder->getFormEntry();

            $entry->setAttribute('domain', $domain);
            $entry->setAttribute('site_id', $res['site_id']);
            $entry->setAttribute('response', json_encode($res));
            $entry->save();

            $builder->setFormEntry($entry);
            $messages->success(trans('streams::message.create_success', ['name' => $domain]));

            /**
             * Run Recipes
             */
            $runner = new RecipeRunner();
            foreach ($recipes as $recipe) {
                $runner->run($entry->getAttribute('site_id'), $recipe['value']);
            }
        }
    }
}
