<?php namespace Visiosoft\DeployModule\Site\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class SiteFormBuilder extends FormBuilder
{

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'domain' => [
            'placeholder' => 'example.com',
        ],
        'username' => [
            'label' => 'module::field.username.name',
            'type' => 'anomaly.field_type.text',
            'placeholder' => 'example',
        ],
        'php' => [
            'label' => 'module::field.php.name',
            'type' => 'anomaly.field_type.text',
            'placeholder' => '7.4',
            'value' => '7.4',
        ],
        'basepath' => [
            'label' => 'module::field.basepath.name',
            'type' => 'anomaly.field_type.text',
            'placeholder' => 'public',
            'value' => 'public',
        ],
        'recipes' => [
            'label' => 'module::field.recipes.name',
            'type' => 'anomaly.field_type.tags',
            'placeholder' => 'recipe_key',
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'redirect'=> '/admin/deploy',
        'success_message' => false,
        'order_by' => [
            'id' => 'DESC'
        ],
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [];

}
