<?php

namespace Visiosoft\DeployModule\Site\Command;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\Streams\Platform\Support\Collection;
use Visiosoft\SiteModule\Helpers\Log;

class RecipeRunner
{
    protected $messages;

    public function __construct()
    {
        $this->messages = app(MessageBag::class);
    }

    public function run($siteId, $recipeKey)
    {
        try {
            $endpointURL = setting_value('visiosoft.module.deploy::endpoint_url');
            $apiKey = setting_value('visiosoft.module.deploy::api_key');

            if (!$endpointURL || !$apiKey) {
                $this->messages->error(trans('module::message.update_api_settings'));
                return null;
            }

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => $endpointURL . '/api/recipes/run',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => [
                    'siteId' => $siteId,
                    'recipeKey' => $recipeKey,
                ],
                CURLOPT_HTTPHEADER => array(
                    'Accept: application/json',
                    'Authorization: Apikey ' . $apiKey
                ),
            ));

            $response = curl_exec($curl);
            curl_close($curl);

            $response = new Collection(json_decode($response, true));

            if ($response->has('errors') && count($response->get('errors'))) {
                foreach ($response->get('errors') as $fields) {
                    if (is_array($fields)) {
                        foreach ($fields as $error) {
                            $this->messages->error($error);
                        }
                    } else {
                        $this->messages->error($fields);
                    }
                }
            } else {
                $this->messages->success(trans('streams::message.create_success', ['name' => $recipeKey]));
            }
        } catch (\Exception $exception) {
            $this->messages->error($exception->getMessage());
            (new Log())->createLog('run_recipe_errors', $exception);
        }
    }
}