<?php namespace Visiosoft\DeployModule\Jobs;

use Anomaly\Streams\Platform\Support\Collection;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\DeployModule\Helpers\HandleError;
use Visiosoft\DeployModule\Server\Contract\ServerRepositoryInterface;

class RunRecipe implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $siteUUID;
    protected $recipeKey;
    protected array $parameters;

    public function __construct($siteUUID, $recipeKey, array $parameters = [])
    {
        $this->siteUUID = $siteUUID;
        $this->recipeKey = $recipeKey;
        $this->parameters = $parameters;
    }

    public function handle(ServerRepositoryInterface $serverRepository)
    {
        $defaultServer = setting_value('visiosoft.module.deploy::default_demo_server');

        if (!$defaultServer || !$server = $serverRepository->find($defaultServer)) {
            throw new \Exception(trans('module::message.update_api_settings'));
        }

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $server->getEndpointURL() . '/api/recipes/run',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array_merge([
                'siteId' => $this->siteUUID,
                'recipeKey' => $this->recipeKey,
            ], $this->parameters),
            CURLOPT_HTTPHEADER => array(
                'Accept: application/json',
                'Authorization: Apikey ' . $server->getApiKey()
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $response = new Collection(json_decode($response, true));

        if ($response->has('errors') && count($response->get('errors'))) {
            dispatch_sync(new HandleError($response->get('errors')));
        }

        return $response;
    }
}
