<?php namespace Visiosoft\DeployModule\Site\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\Streams\Platform\Support\Collection;
use Visiosoft\DeployModule\Jobs\CreateSite;
use Visiosoft\DeployModule\Jobs\RunRecipe;

class SiteFormHandler
{
    public function handle(SiteFormBuilder $builder, MessageBag $messages)
    {
        if (!$builder->canSave()) {
            return;
        }

        $username = $builder->getPostValue('username');
        $domain = $builder->getPostValue('domain');
        $php = $builder->getPostValue('php');
        $basepath = $builder->getPostValue('basepath');
        $recipes = json_decode($builder->getPostValue('recipes'), true);
        $recipes = new Collection($recipes);

        try {
            $creator = new CreateSite($username, $domain, $php, $basepath);
            $res = $creator->handle();

            $entry = $builder->getFormEntry();

            $entry->setAttribute('domain', $domain);
            $entry->setAttribute('site_id', $res['site_id']);
            $entry->setAttribute('response', json_encode($res));
            $entry->save();

            $builder->setFormEntry($entry);
            $messages->success(trans('streams::message.create_success', ['name' => $domain]));

            /**
             * Run Recipes
             */
            foreach ($recipes as $recipe) {
                dispatch_sync(new RunRecipe($entry->getAttribute('site_id'), $recipe['value']));
            }
        } catch (\Exception $exception) {
            $messages->error($exception->getMessage());
            $builder->setFormResponse(redirect('/admin/deploy/create'));
            return;
        }
    }
}
