<?php namespace Visiosoft\DeployModule\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class UpdateSite implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $siteId;

    public function __construct($siteId)
    {
        $this->siteId = $siteId;
    }

    public function handle(SiteRepositoryInterface $siteRepository)
    {
        $site = $siteRepository->find($this->siteId);

        $uuid = $site->getAttribute('site_uuid');

        dispatch_sync(new RunRecipe($uuid, 'update-site'));
    }
}