<?php namespace Visiosoft\DeployModule\Jobs;

use Anomaly\Streams\Platform\Support\Collection;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\DeployModule\Helpers\HandleError;

class CreateSite implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $username;
    protected $domain;
    protected $php;
    protected $basepath;

    public function __construct($username, $domain, $php = '7.4', $basepath = 'public')
    {
        $this->username = $username;
        $this->domain = $domain;
        $this->php = $php;
        $this->basepath = $basepath;
    }

    public function handle()
    {
        $endpointURL = setting_value('visiosoft.module.deploy::endpoint_url');
        $apiKey = setting_value('visiosoft.module.deploy::api_key');

        if (!$endpointURL || !$apiKey) {
            throw new \Exception(trans('module::message.update_api_settings'));
        }

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpointURL . '/api/sites',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => [
                'username' => $this->username,
                'domain' => $this->domain,
                'php' => $this->php,
                'basepath' => $this->basepath
            ],
            CURLOPT_HTTPHEADER => array(
                'Accept: application/json',
                'Authorization: Apikey ' . $apiKey
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $response = new Collection(json_decode($response, true));

        if ($response->has('errors') && count($response->get('errors'))) {
            dispatch_sync(new HandleError($response->get('errors')));
        }

        return $response->get('data');
    }
}
