<?php namespace Visiosoft\DeployModule\Listeners;

use Visiosoft\DeployModule\Jobs\AddAddon;
use Visiosoft\SiteModule\Site\Event\AddMultipleAddonSite;

class DeployInstallAddons
{
    public function handle(AddMultipleAddonSite $event)
    {
        $addons = $event->getAddonArray();
        $site = $event->getSite();

        foreach ($addons as $addon) {
            AddAddon::dispatch($site->getId(), $addon['type'], $addon['name'])->onQueue('site-builder');
        }
    }
}
