<?php namespace Visiosoft\DeployModule\Jobs;

use Anomaly\Streams\Platform\Support\Collection;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\DeployModule\Helpers\HandleError;
use Visiosoft\DeployModule\Server\Contract\ServerRepositoryInterface;

class CreateSite implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $username;
    protected $domain;
    protected $php;
    protected $basepath;

    public function __construct($username, $domain, $php = '7.4', $basepath = 'public')
    {
        $this->username = $username;
        $this->domain = $domain;
        $this->php = $php;
        $this->basepath = $basepath;
    }

    public function handle()
    {
        $servers = app(ServerRepositoryInterface::class);
        $defaultServer = setting_value('visiosoft.module.deploy::default_demo_server');

        if (!$defaultServer || !$server = $servers->find($defaultServer)) {
            throw new \Exception(trans('module::message.update_api_settings'));
        }

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $server->getEndpointURL() . '/api/sites',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => [
                'username' => $this->username,
                'domain' => $this->domain,
                'php' => $this->php,
                'basepath' => $this->basepath
            ],
            CURLOPT_HTTPHEADER => array(
                'Accept: application/json',
                'Authorization: Apikey ' . $server->getApiKey()
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $response = new Collection(json_decode($response, true));

        if ($response->has('errors') && count($response->get('errors'))) {
            dispatch_sync(new HandleError($response->get('errors')));
        }

        return $response->get('data');
    }
}
