<?php namespace Visiosoft\DeployModule\Jobs;

use Anomaly\Streams\Platform\Support\Collection;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\DeployModule\Helpers\HandleError;
use Visiosoft\DeployModule\Server\Contract\ServerRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class AddSSL implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $siteId;
    protected $domain;

    public function __construct($siteId, $domain)
    {
        $this->siteId = $siteId;
        $this->domain = $domain;
    }

    public function handle(SiteRepositoryInterface $siteRepository, ServerRepositoryInterface $serverRepository)
    {
        $defaultServer = setting_value('visiosoft.module.deploy::default_demo_server');

        if (!$defaultServer || !$server = $serverRepository->find($defaultServer)) {
            throw new \Exception(trans('module::message.update_api_settings'));
        }

        $site = $siteRepository->find($this->siteId);

        $uuid = $site->getAttribute('site_uuid');

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $server->getEndpointURL() . '/api/alias/ssl',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => [
                'siteId' => $uuid,
                'domain' => $this->domain,
            ],
            CURLOPT_HTTPHEADER => array(
                'Accept: application/json',
                'Authorization: Apikey ' . $server->getApiKey()
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $response = new Collection(json_decode($response, true));

        if ($response->has('errors') && count($response->get('errors'))) {
            dispatch_sync(new HandleError($response->get('errors')));
        }

        return $response->get('data');
    }
}