<?php namespace Visiosoft\DeployModule\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class AddAddon implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $siteId;
    protected $addonType;
    protected $addonName;

    public function __construct($siteId, $addonType, $addonName)
    {
        $this->siteId = $siteId;
        $this->addonType = $addonType;
        $this->addonName = $addonName;
    }

    public function handle(SiteRepositoryInterface $siteRepository)
    {
        $site = $siteRepository->find($this->siteId);

        $uuid = $site->getAttribute('site_uuid');

        // add addon carts
        dispatch_sync(new RunRecipe($uuid, 'install-addon', [
            'addonNamespace' => 'visiosoft',
            'addonType' => $this->addonType,
            'addonName' => $this->addonName,
        ]));
    }
}