<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleDeployCreateServerStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'server',
        'title_column' => 'server_name',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'server_name' => 'anomaly.field_type.text',
        'server_endpoint' => 'anomaly.field_type.text',
        'server_api_key' => 'anomaly.field_type.text',
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'server_name' => [
            'required' => true,
        ],
        'server_endpoint' => [
            'required' => true,
        ],
        'server_api_key' => [
            'required' => true,
        ],
    ];

}
