<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleDeployCreateSitesStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'sites',
        'title_column' => 'domain',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'domain' => 'anomaly.field_type.text',
        'site_id' => 'anomaly.field_type.text',
        'response' => 'anomaly.field_type.textarea',
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'domain' => [
            'required' => true,
            'unique' => true,
        ],
        'site_id' => [
            'required' => true,
        ],
        'response' => [
            'required' => true,
        ],
    ];

}
