<?php namespace Visiosoft\DeployModule\Jobs;

use Anomaly\Streams\Platform\Support\Collection;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\DeployModule\Helpers\HandleError;

class RunRecipe implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $uuid;
    protected $recipeKey;
    public function __construct($uuid, $recipeKey)
    {
        $this->uuid = $uuid;
        $this->recipeKey = $recipeKey;
    }

    public function handle()
    {
        $endpointURL = setting_value('visiosoft.module.deploy::endpoint_url');
        $apiKey = setting_value('visiosoft.module.deploy::api_key');

        if (!$endpointURL || !$apiKey) {
            throw new \Exception(trans('module::message.update_api_settings'));
        }

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpointURL . '/api/recipes/run',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => [
                'siteId' => $this->uuid,
                'recipeKey' => $this->recipeKey,
            ],
            CURLOPT_HTTPHEADER => array(
                'Accept: application/json',
                'Authorization: Apikey ' . $apiKey
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $response = new Collection(json_decode($response, true));

        if ($response->has('errors') && count($response->get('errors'))) {
            dispatch_sync(new HandleError($response->get('errors')));
        }

        return $response;
    }
}
