$(document).on('ajaxComplete ready', function () {

    $('form[name=create]').on('submit', function (e) {
        e.preventDefault();

        jQuery.ajax({
            type: "POST",
            url: config_create.endpointURL + '/api/sites',
            "headers": {
                "Authorization": "Apikey " + config_create.apiKey
            },
            data: $(this).serialize(),
            success: function (response) {
                if (response.success) {
                    $('ol[class=breadcrumb]').next().html(`<div class="alert alert-success">${config_create.successMessage}</div>`);
                    parseSuccessResponse(response.data);
                }
            },
            error: function (xhr, ajaxOptions, thrownError) {
                if (typeof xhr.responseJSON == "undefined") {
                    swal("Oops", thrownError, "warning");
                } else {
                    parseError(xhr.responseJSON.errors);
                }
            }
        });

    });
});

function parseSuccessResponse(data) {
    let output = '';

    $.each(data, function (field, value) {
        output += `<p class="font-weight-bold">${field}:${value}</p>`;
    })

    $('ol[class=breadcrumb]').next().html($('ol[class=breadcrumb]').next().html() +
        `<div class="alert alert-info">${output}</div>`);
}

function parseError(errors) {
    let output = '';

    $.each(errors, function (field, messages) {
        if (Array.isArray(messages)) {
            $.each(messages, function (key, message) {
                output += `<div class="alert alert-danger">${message}</div>`;
            })
        } else {
            output += `<div class="alert alert-danger">${messages}</div>`;
        }
    })

    $('ol[class=breadcrumb]').next().html(output);
}