<?php namespace Visiosoft\DeployModule\Listeners;

use Illuminate\Support\Facades\Bus;
use Visiosoft\DeployModule\Jobs\AddSSL;
use Visiosoft\DeployModule\Jobs\CreateOpenclassify;
use Visiosoft\SiteModule\Site\Event\BuildSite;

class DeployCreate
{
    public function handle(BuildSite $event)
    {
        $site = $event->getSite();

        $username = $event->getUser()->username;
        $email = $event->getUser()->email;
        $password = $event->getPassword();

        Bus::chain([
            new CreateOpenclassify($site->getId(), $username, $email, $password),
            (new AddSSL($site->getId(), $site->getUrl()))->delay(120)
        ])->onQueue('site-builder')->dispatch();
    }
}
