<?php namespace Visiosoft\DemandModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Image\Image;
use Illuminate\Http\Request;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;

class ApiController extends PublicController
{
    private $image;
    private $typeRepository;

    public function __construct(Image $image, TypeRepositoryInterface $typeRepository)
    {
        parent::__construct();

        $this->image = $image;
        $this->typeRepository = $typeRepository;
    }

    public function getImage(Request $request)
    {
        $image = $this->image->make($request->path, 'path');

        return $image->url();
    }

    public function getInquiryTypes()
    {
        $inquiryTypes = $this->typeRepository->all();

        foreach ($inquiryTypes as $inquiryType) {
            $inquiryType->setAttribute('logo_url', $inquiryType->inquiry_logo->url());
        }

        return $inquiryTypes;
    }
}
