<?php namespace Visiosoft\DemandModule;

use Visiosoft\DemandModule\Http\Controller\Admin\AssignmentsController;
use Visiosoft\DemandModule\Http\Controller\Admin\FieldsController;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Assignment\AssignmentRouter;
use Anomaly\Streams\Platform\Field\FieldRouter;
use Anomaly\Streams\Platform\Model\Demand\DemandTypesEntryModel;
use Visiosoft\DemandModule\Demand\Contract\DemandRepositoryInterface;
use Visiosoft\DemandModule\Demand\DemandRepository;
use Anomaly\Streams\Platform\Model\Demand\DemandDemandsEntryModel;
use Visiosoft\DemandModule\Demand\DemandModel;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Visiosoft\DemandModule\Type\TypeModel;
use Visiosoft\DemandModule\Type\TypeRepository;

class DemandModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/demand'           => 'Visiosoft\DemandModule\Http\Controller\Admin\DemandsController@index',
        'admin/demand/create'    => 'Visiosoft\DemandModule\Http\Controller\Admin\DemandsController@create',
        'admin/demand/edit/{id}' => 'Visiosoft\DemandModule\Http\Controller\Admin\DemandsController@edit',

        'api/get-image' => 'Visiosoft\DemandModule\Http\Controller\ApiController@getImage',
        'api/get-inquiry-types' => 'Visiosoft\DemandModule\Http\Controller\ApiController@getInquiryTypes',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\DemandModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\DemandModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\DemandModule\Event\ExampleEvent::class => [
        //    Visiosoft\DemandModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\DemandModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        DemandDemandsEntryModel::class => DemandModel::class,
        DemandTypesEntryModel::class => TypeModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        DemandRepositoryInterface::class => DemandRepository::class,
        TypeRepositoryInterface::class => TypeRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional routes.
     *
     * @param FieldRouter $fields
     * @param AssignmentRouter $assignments
     */
    public function map(FieldRouter $fields, AssignmentRouter $assignments) {
        $fields->route($this->addon, FieldsController::class);
        $assignments->route($this->addon, AssignmentsController::class, 'admin/demand/types');
    }

}
