<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleDemandCreateTypesStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'types',
        'title_column' => 'inquiry',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => true,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'inquiry'         => [
            'translatable' => true,
            'required'     => true,
        ],
        'inquiry_type'         => [
            'translatable' => true,
            'required' => true,
        ],
        'inquiry_logo' => [
            'required' => true,
        ],
        'description'  => [
            'translatable' => true,
        ],
    ];

}
