<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleDemandCreateDemandFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Anomaly\UsersModule\User\UserModel::class
            ]
        ],
        'country' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\LocationModule\Country\CountryModel::class
            ]
        ],
        'city' => 'anomaly.field_type.select',
        'district' => 'anomaly.field_type.select',
        'neighborhood' => 'anomaly.field_type.select',
        "type" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related" => \Visiosoft\DemandModule\Type\TypeModel::class,
            ]
        ],
        'inquiry' => 'anomaly.field_type.text',
        "inquiry_logo" => [
            "type"   => "anomaly.field_type.file",
            "config" => [
                "folders"       => ['images'],
            ]
        ],
        'inquiry_type' => 'anomaly.field_type.text',
        'description'  => 'anomaly.field_type.textarea',
        'entry'            => 'anomaly.field_type.polymorphic',
    ];

}
