<?php namespace Visiosoft\DemandModule\Demand\Form\Command;

use Visiosoft\DemandModule\Entry\Form\EntryFormBuilder;
use Visiosoft\DemandModule\Demand\Form\DemandEntryFormBuilder;
use Visiosoft\DemandModule\Type\Contract\TypeInterface;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Http\Request;

class AddEntryFormFromRequest
{

    use DispatchesJobs;

    /**
     * The multiple form builder.
     *
     * @var DemandEntryFormBuilder
     */
    protected $builder;

    /**
     * Create a new AddEntryFormFromRequest instance.
     *
     * @param DemandEntryFormBuilder $builder
     */
    public function __construct(DemandEntryFormBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     *
     * @param TypeRepositoryInterface $types
     * @param EntryFormBuilder $builder
     * @param Request $request
     */
    public function handle(TypeRepositoryInterface $types, EntryFormBuilder $builder, Request $request)
    {
        /* @var TypeInterface $type */
        $type = $types->find($request->get('type'));

        $this->builder->addForm(
            'entry',
            $builder->setModel($type->getEntryModelName())
        );
    }
}
