<?php namespace Visiosoft\DemandModule\Type\Command;

use Visiosoft\DemandModule\Demand\Contract\DemandInterface;
use Visiosoft\DemandModule\Demand\Contract\DemandRepositoryInterface;
use Visiosoft\DemandModule\Type\Contract\TypeInterface;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Illuminate\Foundation\Bus\DispatchesJobs;

class UpdateDemands
{

    use DispatchesJobs;

    /**
     * The demand type instance.
     *
     * @var TypeInterface
     */
    protected $type;

    /**
     * Update a new UpdateDemands instance.
     *
     * @param TypeInterface $type
     */
    public function __construct(TypeInterface $type)
    {
        $this->type = $type;
    }

    /**
     * Handle the command.
     *
     * @param TypeRepositoryInterface $types
     * @param DemandRepositoryInterface $demands
     */
    public function handle(TypeRepositoryInterface $types, DemandRepositoryInterface $demands)
    {
        /* @var TypeInterface $type */
        if (!$type = $types->find($this->type->getId())) {
            return;
        }

        /* @var DemandInterface $demand */
        foreach ($type->getDemands() as $demand) {
            $demands->save($demand->setAttribute('entry_type', $this->type->getEntryModelName()));
        }
    }
}
