<?php namespace Visiosoft\DemandModule\Demand;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\DemandModule\Type\Contract\TypeInterface;
use Visiosoft\DemandModule\Demand\Contract\DemandInterface;
use Anomaly\Streams\Platform\Model\Demand\DemandDemandsEntryModel;
use Visiosoft\LocationModule\City\CityModel;
use Visiosoft\LocationModule\District\DistrictModel;
use Visiosoft\LocationModule\Neighborhood\NeighborhoodModel;

class DemandModel extends DemandDemandsEntryModel implements DemandInterface
{
    public function getType()
    {
        return $this->type;
    }

    public function getEntry()
    {
        return $this->entry;
    }

    public function getEntryId()
    {
        $entry = $this->getEntry();

        return $entry->getId();
    }

    public function getCity()
    {
        return $this->belongsTo(CityModel::class, 'city');
    }

    public function getDistrict()
    {
        return $this->belongsTo(DistrictModel::class, 'district');
    }

    public function getNeighborhood()
    {
        return $this->belongsTo(NeighborhoodModel::class, 'neighborhood');
    }
}
