<?php namespace Visiosoft\DemandModule\Type;

use Illuminate\Support\Facades\DB;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class TypeRepository extends EntryRepository implements TypeRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var TypeModel
     */
    protected $model;

    /**
     * Create a new TypeRepository instance.
     *
     * @param TypeModel $model
     */
    public function __construct(TypeModel $model)
    {
        $this->model = $model;
    }

    public function getInquiries() {
        $inquiries = DB::table('demand_types')
            ->groupBy(DB::raw("SUBSTRING_INDEX(type_slug, '_', 1)"))->pluck('id');

        return $this
            ->newQuery()
            ->whereIn('id', $inquiries)
            ->get();
    }

    public function getInquiryTypesBySlug($slug) {
        $inquiryTypes = $this->newQuery()->where('type_slug', 'LIKE', "$slug%")->get();

        foreach ($inquiryTypes as $inquiryType) {
            $inquiryType->setAttribute('logo_url', $inquiryType->inquiry_logo->make()->url());
        }

        return $inquiryTypes;
    }

    public function getInquiryTypeImageBySlug($slug) {
        return $this->newQuery()
            ->where('type_slug', 'LIKE', "$slug%")
            ->whereNotNull('type_image_id')
            ->first();
    }

    public function getInquiryTypeBySlug($slug) {
        return $this->findBy('type_slug', $slug);
    }
}
