<?php namespace Visiosoft\DemandModule\Seed;

use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Image\Image;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;

class TypeSeeder extends Seeder
{

    private $typeRepository;
    private $fileRepository;
    private $image;
    private $folderRepository;

    public function __construct(
        TypeRepositoryInterface $typeRepository,
        FileRepositoryInterface $fileRepository,
        Image $image,
        FolderRepositoryInterface $folderRepository
    )
    {
        parent::__construct();
        $this->typeRepository = $typeRepository;
        $this->fileRepository = $fileRepository;
        $this->image = $image;
        $this->folderRepository = $folderRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $types = [
            [
                'type_slug' => 'buy_house',
                'inquiry_logo' => 'house.png',
                'inquiry' => 'Buy',
                'inquiry_type' => 'House',
            ],
            [
                'type_slug' => 'buy_land',
                'inquiry_logo' => 'land.png',
                'inquiry' => 'Buy',
                'inquiry_type' => 'Land',
            ],
            [
                'type_slug' => 'lend_land',
                'inquiry_logo' => 'land.png',
                'inquiry' => 'Lend',
                'inquiry_type' => 'Land',
            ],
        ];

        foreach ($types as $type) {
            $demandType = $this->typeRepository->findBy('type_slug', $type['type_slug']);
            if ($demandType) {
                $demandType->forceDelete();
            }
            $logo = $this->savePhoto($type['inquiry_logo']);
            $this->typeRepository->create([
                'inquiry' => $type['inquiry'],
                'inquiry_type' => $type['inquiry_type'],
                'type_slug' => $type['type_slug'],
                'inquiry_logo_id' => $logo->getId(),
            ]);
        }
    }

    public function savePhoto($name)
    {
        $imagesFolder = $this->folderRepository->findBySlug('images');
        $logo = $this->fileRepository->findByNameAndFolder($name, $imagesFolder);
        if (!$logo) {$logo = $this->image->make('visiosoft.module.demand::images/' . $name);
            $contents = file_get_contents($logo->url(),false, stream_context_create([
                    "ssl" => [
                        "verify_peer" => false,
                        "verify_peer_name" => false,
                    ]
                ]));
            $target = base_path() . "/storage/streams/default/files-module/local/images/" . $name;
            file_put_contents($target, $contents);
            $logo = $this->fileRepository->create([
                'folder_id' => $imagesFolder->getId(),
                'name' => $name,
                'disk_id' => 1,
                'size' => 1,
                'mime_type' => "image/" . $logo->getExtension(),
                'extension' => $logo->getExtension(),
            ]);
        }
        return $logo;
    }
}
