<?php namespace Visiosoft\DemandModule\Seed;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class RepeaterSeeder extends Seeder
{

    /**
     * @var StreamRepositoryInterface
     */
    private $streamRepository;
    /**
     * @var FieldRepositoryInterface
     */
    private $fieldRepository;
    /**
     * @var AssignmentRepositoryInterface
     */
    private $assignmentRepository;

    public function __construct(
        StreamRepositoryInterface $streamRepository,
        FieldRepositoryInterface $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository
    )
    {
        parent::__construct();
        $this->streamRepository = $streamRepository;
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $optionsRepeater = $this->streamRepository->findBySlugAndNamespace('options_repeater', 'repeater');
        if ($optionsRepeater) {
            $optionsRepeater->delete();
        }
        $optionsRepeater = $this->streamRepository->create([
            'name' => 'Options Repeater',
            'namespace' => 'repeater',
            'slug' => 'options_repeater',
            'prefix' => 'repeater_',
            'translatable' => 1,
        ]);

        // Assign repeater fields
        $optionsFields = [
            'option_name' => [
                'name' => 'Option Name',
                'namespace' => 'repeater',
                'slug' => 'option_name',
                'type' => 'anomaly.field_type.text',
                "config" => [
                    "type"          => "text",
                    "max"           => 255,
                ],
                "assignment_config" => [
                    'required' => 1,
                    'unique' => 1,
                    'translatable' => 1
                ]
            ],
            'option_photo' => [
                'name' => 'Option Photo',
                'namespace' => 'repeater',
                'slug' => 'option_photo',
                'type' => 'anomaly.field_type.file',
                "config" => [
                    "folders" => ["images"],
                ],
                "assignment_config" => [
                    'required' => 1
                ]
            ]
        ];

        foreach ($optionsFields as $optionsField) {
            $field = $this->fieldRepository->findBySlugAndNamespace($optionsField['slug'], $optionsField['namespace']);
            if ($field) {
                $field->delete();
            }
            $field = $this->fieldRepository->create([
                'name' => $optionsField['name'],
                'namespace' => $optionsField['namespace'],
                'slug' => $optionsField['slug'],
                'type' => $optionsField['type'],
                'locked' => 0,
                "config" => $optionsField['config']
            ]);
            $this->assignmentRepository->create(array_merge([
                'stream_id' => $optionsRepeater->getId(),
                'field_id' => $field->id,
                'label' => $optionsField['name']
            ], $optionsField['assignment_config']));
        }
    }
}
