<?php namespace Visiosoft\DemandModule\Demand\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class DemandTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'id' => 'entry.id',
        'inquiry' => [
            'value' => 'entry.type.inquiry'
        ],
        'inquiry_type' => [
            'value' => 'entry.type.inquiry_type'
        ],
        'user' => [
            'value' => 'entry.user.name'
        ],
        'email' => [
            'value' => 'entry.user.email'
        ],
        'phone' => [
            'value' => 'entry.user.gsm_phone'
        ],
        'submitted_at' => [
            'value' => 'entry.created_at|date'
        ]
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'offer' => [
            'href' => '/offers/select?demand={entry.id}',
        ],
        'edit',
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => [
            'id' => 'desc'
        ]
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
