<?php namespace Visiosoft\DemandModule\Type;

use Visiosoft\DemandModule\Type\Command\CreateStream;
use Visiosoft\DemandModule\Type\Command\DeleteStream;
use Visiosoft\DemandModule\Type\Command\UpdateDemands;
use Visiosoft\DemandModule\Type\Command\UpdateStream;
use Visiosoft\DemandModule\Type\Contract\TypeInterface;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryObserver;

class TypeObserver extends EntryObserver
{

    /**
     * Fired after a demand type is created.
     *
     * @param EntryInterface|TypeInterface $entry
     */
    public function created(EntryInterface $entry)
    {
        $this->commands->dispatch(new CreateStream($entry));

        parent::created($entry);
    }

    /**
     * Fired before a demand type is updated.
     *
     * @param EntryInterface|TypeInterface $entry
     */
    public function updating(EntryInterface $entry)
    {
        $this->commands->dispatch(new UpdateStream($entry));
        $this->commands->dispatch(new UpdateDemands($entry));

        parent::updating($entry);
    }

    /**
     * Fired after a demand type is deleted.
     *
     * @param EntryInterface|TypeInterface $entry
     */
    public function deleted(EntryInterface $entry)
    {
        $this->commands->dispatch(new DeleteStream($entry));

        parent::deleted($entry);
    }
}
