<?php namespace Visiosoft\DemandModule\Service\Form;

use Visiosoft\DemandModule\Entry\Form\EntryFormBuilder;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Anomaly\Streams\Platform\Ui\Form\Multiple\MultipleFormBuilder;

class ServiceEntryFormBuilder extends MultipleFormBuilder
{

    /**
     * The form buttons.
     *
     * @var array
     */
    protected $buttons = [
        'cancel',
        'change' => [
            'enabled'     => 'edit',
            'data-toggle' => 'modal',
            'data-target' => '#modal',
            'href'        => 'admin/demand/services/types/change/{request.route.parameters.id}',
        ]
    ];

    /**
     * Fired after the entry form is saved.
     *
     * After the entry form is saved take the
     * entry and use it to populate the service
     * before it saves directly after.
     *
     * @param EntryFormBuilder $builder
     */
    public function onSavedEntry(EntryFormBuilder $builder)
    {
        /* @var FormBuilder $form */
        $form = $this->forms->get('service');

        $service = $form->getFormEntry();

        $entry = $builder->getFormEntry();

        $service->entry_id   = $entry->getId();
        $service->entry_type = get_class($entry);
    }

    /**
     * Get the contextual entry ID.
     *
     * @return int|mixed|null
     */
    public function getContextualId()
    {
        /* @var FormBuilder $form */
        $form = $this->forms->get('service');

        return $form->getContextualId();
    }
}
