<?php namespace Visiosoft\DemandModule\Service\Form\Command;

use Visiosoft\DemandModule\Entry\Form\EntryFormBuilder;
use Visiosoft\DemandModule\Service\Contract\ServiceInterface;
use Visiosoft\DemandModule\Service\Form\ServiceEntryFormBuilder;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Illuminate\Foundation\Bus\DispatchesJobs;

class AddEntryFormFromService
{

    use DispatchesJobs;

    /**
     * The multiple form builder.
     *
     * @var ServiceEntryFormBuilder
     */
    protected $builder;

    /**
     * The service instance.
     *
     * @var ServiceInterface
     */
    protected $service;

    /**
     * Create a new AddEntryFormFromService instance.
     *
     * @param ServiceEntryFormBuilder $builder
     * @param ServiceInterface $service
     */
    public function __construct(ServiceEntryFormBuilder $builder, ServiceInterface $service)
    {
        $this->builder = $builder;
        $this->service    = $service;
    }

    /**
     * Handle the command.
     *
     * @param EntryFormBuilder $builder
     * @param TypeRepositoryInterface $types
     */
    public function handle(EntryFormBuilder $builder, TypeRepositoryInterface $types)
    {
        $type = $this->service->getType();

        if (request()->has('type')) {

            $type = $types->find(request('type'));

            $this->builder->setOption('redirect', 'admin/demand/services/edit/' . $this->service->getId());
        }

        $builder->setModel($type->getEntryModelName());
        $builder->setEntry($this->service->getEntryId());

        $this->builder->addForm('entry', $builder);
    }
}
