<?php namespace Visiosoft\DemandModule\Seed;

use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Image\Image;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterOptionsRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterOptionsRepeaterEntryTranslationsModel;
use Visiosoft\DemandModule\Option\Contract\OptionRepositoryInterface;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;

class OptionSeeder extends Seeder
{

    /**
     * @var OptionRepositoryInterface
     */
    private $optionRepository;
    /**
     * @var TypeRepositoryInterface
     */
    private $typeRepository;
    /**
     * @var RepeaterOptionsRepeaterEntryModel
     */
    private $optionsRepeaterEntryModel;
    /**
     * @var RepeaterOptionsRepeaterEntryTranslationsModel
     */
    private $optionsRepeaterEntryTranslationsModel;
    /**
     * @var FolderRepositoryInterface
     */
    private $folderRepository;
    /**
     * @var FileRepositoryInterface
     */
    private $fileRepository;
    /**
     * @var Image
     */
    private $image;

    public function __construct(
        OptionRepositoryInterface $optionRepository,
        TypeRepositoryInterface $typeRepository,
        RepeaterOptionsRepeaterEntryModel $optionsRepeaterEntryModel,
        RepeaterOptionsRepeaterEntryTranslationsModel $optionsRepeaterEntryTranslationsModel,
        FolderRepositoryInterface $folderRepository,
        FileRepositoryInterface $fileRepository,
        Image $image
    )
    {
        parent::__construct();
        $this->optionRepository = $optionRepository;
        $this->typeRepository = $typeRepository;
        $this->optionsRepeaterEntryModel = $optionsRepeaterEntryModel;
        $this->optionsRepeaterEntryTranslationsModel = $optionsRepeaterEntryTranslationsModel;
        $this->folderRepository = $folderRepository;
        $this->fileRepository = $fileRepository;
        $this->image = $image;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $timeFrameOptions = [
            ['option_name' => '1-3 months', 'option_photo' => '1-3.png'],
            ['option_name' => '4-6 months', 'option_photo' => '4-6.png'],
            ['option_name' => '6+ months', 'option_photo' => '6-.png'],
        ];

        $timeFrameOptionsIds = array();
        foreach ($timeFrameOptions as $timeFrameOption) {
            $option = $this->optionsRepeaterEntryTranslationsModel->newQuery()
                ->where('option_name', $timeFrameOption['option_name'])->first();
            if ($option) {
                $this->optionsRepeaterEntryModel->newQuery()->find($option->entry_id)->delete();
                $option->delete();
            }
            $photo = $this->savePhoto($timeFrameOption['option_photo']);
            $option = $this->optionsRepeaterEntryModel->newQuery()->create([
                'option_name' => $timeFrameOption['option_name'],
                'option_photo_id' => $photo->id,
            ]);
            $timeFrameOptionsIds[] = $option->id;
        }

        $typesSlugs = ['buy_house', 'buy_land', 'lend_land'];
        $types = $this->typeRepository->newQuery()->whereIn('type_slug', $typesSlugs)->pluck('id');

        $repeaterOption = $this->optionRepository->findBy('options_slug', 'time_frame');
        if ($repeaterOption) {
            $repeaterOption->delete();
        }
        $repeaterOption = $this->optionRepository->create([
            'title' => 'Time Frame',
            'options_slug' => 'time_frame',
            'step' => 3,
        ]);
        $repeaterOption->update([
            'related_type' => $types,
            'options' => $timeFrameOptionsIds,
        ]);
    }

    public function savePhoto($name)
    {
        $imagesFolder = $this->folderRepository->findBySlug('images');
        $logo = $this->fileRepository->findByNameAndFolder($name, $imagesFolder);
        if (!$logo) {$logo = $this->image->make('visiosoft.module.demand::images/' . $name);
            $contents = file_get_contents($logo->url());
            $target = base_path() . "/storage/streams/default/files-module/local/images/" . $name;
            file_put_contents($target, $contents);
            $logo = $this->fileRepository->create([
                'folder_id' => $imagesFolder->getId(),
                'name' => $name,
                'disk_id' => 1,
                'size' => 1,
                'mime_type' => "image/" . $logo->getExtension(),
                'extension' => $logo->getExtension(),
            ]);
        }
        return $logo;
    }
}
